<?php
include "config.php";
if (!isset($_SESSION["admin"])) {
    header("Location: login");
    exit;
}

$file = __DIR__ . "/info.json";
if (!file_exists($file)) {
    file_put_contents($file, json_encode([], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}
$data = json_decode(file_get_contents($file), true) ?: [];

$msg = "";
$icon = "success";

// Simpan data
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["page"])) {
    $page = $_POST["page"];
    $data[$page] = [
        "situs"     => $_POST["situs"]     ?? "",
        "deposit"   => $_POST["deposit"]   ?? "",
        "metode"    => $_POST["metode"]    ?? "",
        "mata_uang" => $_POST["mata_uang"] ?? "",
        "promo"     => $_POST["promo"]     ?? ""
    ];
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    header("Location: info_edit?msg=" . urlencode("✅ Data untuk halaman '$page' berhasil disimpan!") . "&icon=success");
    exit;
}

// Hapus data
if (isset($_GET["delete"])) {
    $delPage = $_GET["delete"];
    if (isset($data[$delPage])) {
        unset($data[$delPage]);
        file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }
    header("Location: info_edit?msg=" . urlencode("🗑 Data berhasil dihapus!") . "&icon=success");
    exit;
}

$editPage = $_GET["page"] ?? "";
$current = $editPage && isset($data[$editPage]) ? $data[$editPage] : [
    "situs"     => "",
    "deposit"   => "",
    "metode"    => "",
    "mata_uang" => "",
    "promo"     => ""
];

$msg = $_GET["msg"] ?? "";
$icon = $_GET["icon"] ?? "success";
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kelola Info Slot</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body class="bg-gray-100 p-4 md:p-8">

    <h2 class="text-2xl font-bold mb-4">📊 Kelola Info Tabel</h2>

    <?php if (!empty($msg)): ?>
        <script>
            document.addEventListener("DOMContentLoaded", function () {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: "<?php echo $icon; ?>",
                    title: <?php echo json_encode($msg); ?>,
                    showConfirmButton: false,
                    timer: 2500,
                    timerProgressBar: true
                });
            });
        </script>
    <?php endif; ?>

    <!-- Daftar Halaman -->
    <div class="bg-white p-6 rounded shadow mb-6">
        <h3 class="text-xl font-semibold mb-3">📑 Daftar Halaman</h3>
        <div class="overflow-x-auto">
            <table class="w-full border border-gray-300 text-sm">
                <thead class="bg-gray-200">
                    <tr>
                        <th class="p-2 border">Halaman</th>
                        <th class="p-2 border">Situs</th>
                        <th class="p-2 border">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($data as $pageName => $values): ?>
                    <tr class="odd:bg-white even:bg-gray-50">
                        <td class="p-2 border"><?php echo htmlspecialchars($pageName); ?></td>
                        <td class="p-2 border"><?php echo htmlspecialchars($values["situs"] ?? ""); ?></td>
                        <td class="p-2 border text-center space-x-2">
                            <a href="?page=<?php echo urlencode($pageName); ?>" class="text-blue-600 hover:underline">✏️ Edit</a>
                            <a href="?delete=<?php echo urlencode($pageName); ?>"
                               class="btn-delete text-red-600 hover:underline"
                               data-url="?delete=<?php echo urlencode($pageName); ?>">🗑 Hapus</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    <?php if (empty($data)): ?>
                        <tr><td colspan="3" class="p-4 text-center text-gray-500">Belum ada data info.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Form Tambah / Edit -->
    <div class="bg-white p-6 rounded shadow">
        <h3 class="text-xl font-semibold mb-3">
            <?php echo $editPage ? "✏️ Edit Info Halaman: " . htmlspecialchars($editPage) : "➕ Tambah Halaman Baru"; ?>
        </h3>
        <form method="post" class="space-y-4">
            <div>
                <label class="font-medium">Nama Halaman</label>
                <input type="text" name="page" value="<?php echo htmlspecialchars($editPage); ?>" required class="w-full p-2 border rounded" placeholder="contoh: index atau habanero-index">
            </div>
            <div>
                <label class="font-medium">Nama Situs</label>
                <input type="text" name="situs" value="<?php echo htmlspecialchars($current["situs"] ?? ""); ?>" class="w-full p-2 border rounded">
            </div>
            <div>
                <label class="font-medium">Minimal Deposit</label>
                <input type="text" name="deposit" value="<?php echo htmlspecialchars($current["deposit"] ?? ""); ?>" class="w-full p-2 border rounded">
            </div>
            <div>
                <label class="font-medium">Metode Deposit</label>
                <input type="text" name="metode" value="<?php echo htmlspecialchars($current["metode"] ?? ""); ?>" class="w-full p-2 border rounded">
            </div>
            <div>
                <label class="font-medium">Mata Uang</label>
                <input type="text" name="mata_uang" value="<?php echo htmlspecialchars($current["mata_uang"] ?? ""); ?>" class="w-full p-2 border rounded">
            </div>
            <div>
                <label class="font-medium">Promo</label>
                <input type="text" name="promo" value="<?php echo htmlspecialchars($current["promo"] ?? ""); ?>" class="w-full p-2 border rounded">
            </div>

            <div class="flex flex-wrap gap-3">
                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-500">💾 Simpan</button>
                <a href="dashboard" class="px-4 py-2 bg-gray-500 text-white rounded hover:bg-gray-600">⬅ Kembali</a>
            </div>
        </form>
    </div>

    <script>
    // Konfirmasi hapus dengan SweetAlert2
    document.querySelectorAll('.btn-delete').forEach(btn => {
        btn.addEventListener('click', function (e) {
            e.preventDefault();
            let url = this.getAttribute('data-url');
            Swal.fire({
                title: 'Yakin hapus?',
                text: "Data ini akan dihapus permanen!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = url;
                }
            });
        });
    });
    </script>
</body>
</html>
