<?php
include "config.php";
if (!isset($_SESSION["admin"])) {
    header("Location: login");
    exit;
}

$file = __DIR__ . "/article.json";
if (!file_exists($file)) {
    file_put_contents($file, json_encode([], JSON_PRETTY_PRINT));
}
$data = json_decode(file_get_contents($file), true);

// MODE EDIT
$editSlug = $_GET["edit"] ?? "";
$editData = $editSlug && isset($data[$editSlug]) ? $data[$editSlug] : [
    "title" => "",
    "slug" => "",
    "content" => "",
    "image" => ""
];

// SIMPAN (Create / Update)
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["title"])) {
    $title = $_POST["title"];
    $slug  = $_POST["slug"];
    $content = $_POST["content"];

    // Upload gambar utama (opsional)
    $image = $editData["image"] ?? "";
    if (!empty($_FILES["image"]["name"])) {
        $targetDir = __DIR__ . "/upload/";
        if (!is_dir($targetDir)) mkdir($targetDir);
        $filename = time() . "_" . basename($_FILES["image"]["name"]);
        $targetFile = $targetDir . $filename;
        if (move_uploaded_file($_FILES["image"]["tmp_name"], $targetFile)) {
            $image = "upload/" . $filename;
        }
    }

    // Simpan / update
    $data[$slug] = [
        "title" => $title,
        "slug" => $slug,
        "content" => $content,
        "image" => $image,
        "created_at" => $editSlug ? $editData["created_at"] : date("Y-m-d H:i:s"),
        "updated_at" => date("Y-m-d H:i:s")
    ];

    // Hapus slug lama jika diubah
    if ($editSlug && $editSlug !== $slug) {
        unset($data[$editSlug]);
    }

    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    $msg = $editSlug ? "Artikel berhasil diperbarui!" : "Artikel baru berhasil ditambahkan!";
    $editSlug = $slug;
    $editData = $data[$slug];
}

// HANDLER UPLOAD GAMBAR DARI SUMMERNOTE
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_FILES["file"])) {
    $targetDir = __DIR__ . "/upload/";
    if (!is_dir($targetDir)) mkdir($targetDir);
    $filename = time() . "_" . basename($_FILES["file"]["name"]);
    $targetFile = $targetDir . $filename;
    if (move_uploaded_file($_FILES["file"]["tmp_name"], $targetFile)) {
        echo "upload/" . $filename; // URL gambar dikirim balik ke Summernote
    }
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $editSlug ? "Edit Artikel" : "Tambah Artikel"; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Summernote CSS & JS -->
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
</head>
<body class="bg-gray-100 p-4 md:p-8">

    <h2 class="text-2xl font-bold mb-4"><?php echo $editSlug ? "✏️ Edit Artikel" : "➕ Tambah Artikel"; ?></h2>

    <?php if (!empty($msg)): ?>
        <div class="mb-4 p-3 rounded bg-green-100 text-green-800 font-medium"><?php echo $msg; ?></div>
    <?php endif; ?>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        
        <!-- FORM -->
        <div class="bg-white p-6 rounded shadow">
            <form method="post" enctype="multipart/form-data" class="space-y-4">
                <div>
                    <label class="font-medium">Judul Artikel</label>
                    <input type="text" id="title" name="title" value="<?php echo htmlspecialchars($editData["title"]); ?>" required
                           class="w-full p-2 border rounded">
                </div>

                <div>
                    <label class="font-medium">Slug URL</label>
                    <input type="text" id="slug" name="slug" value="<?php echo htmlspecialchars($editData["slug"]); ?>"
                           placeholder="contoh: artikel-pertama" required
                           class="w-full p-2 border rounded">
                </div>

                <div>
                    <label class="font-medium">Artikel</label>
                    <textarea id="content" name="content"><?php echo htmlspecialchars($editData["content"]); ?></textarea>
                </div>

                <div>
                    <label class="font-medium">Upload Gambar Utama (opsional)</label>
                    <?php if (!empty($editData["image"])): ?>
                        <p class="mb-2">
                            <img src="<?php echo $editData["image"]; ?>" alt="gambar" class="w-32 rounded mb-2"><br>
                            <span class="text-gray-500 text-sm">Gambar saat ini</span>
                        </p>
                    <?php endif; ?>
                    <input type="file" name="image" class="w-full">
                </div>

                <div class="flex flex-wrap gap-2">
                    <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-500">
                        <?php echo $editSlug ? "💾 Update" : "➕ Tambah"; ?>
                    </button>
                    <a href="article_list" class="px-4 py-2 bg-gray-500 text-white rounded hover:bg-gray-600">❌ Batal</a>
                    <a href="article_list" class="px-4 py-2 bg-green-600 text-white rounded hover:bg-green-500">⬅️ Kembali</a>
                </div>
            </form>
        </div>

        <!-- PREVIEW -->
        <div class="bg-white p-6 rounded shadow">
            <h3 class="text-xl font-bold mb-4">👀 Preview Artikel</h3>
            <div class="space-y-4">
                <h2 id="preview-title" class="text-2xl font-bold"><?php echo htmlspecialchars($editData["title"]); ?></h2>
                <div id="preview-content" class="prose max-w-none"><?php echo $editData["content"]; ?></div>
                <?php if (!empty($editData["image"])): ?>
                    <img id="preview-image" src="<?php echo $editData["image"]; ?>" class="w-64 rounded">
                <?php else: ?>
                    <img id="preview-image" class="w-64 rounded hidden">
                <?php endif; ?>
            </div>
        </div>

    </div>

    <script>
    $(document).ready(function() {
      $('#content').summernote({
        placeholder: 'Tulis artikel di sini...',
        tabsize: 2,
        height: 300,
        callbacks: {
          onImageUpload: function(files) {
            for (let i = 0; i < files.length; i++) {
              uploadImage(files[i]);
            }
          },
          onChange: function(contents) {
            $("#preview-content").html(contents);
          }
        }
      });

      function uploadImage(file) {
        let data = new FormData();
        data.append("file", file);
        $.ajax({
          url: "article_add", // endpoint sama
          type: "POST",
          data: data,
          cache: false,
          contentType: false,
          processData: false,
          success: function(url) {
            $('#content').summernote("insertImage", url);
          },
          error: function() {
            alert("Upload gambar gagal!");
          }
        });
      }

      // Auto update preview
      $("#title").on("input", function() {
        $("#preview-title").text($(this).val());
      });

      $("input[name=image]").on("change", function(e) {
        const [file] = e.target.files;
        if (file) {
          $("#preview-image").attr("src", URL.createObjectURL(file)).removeClass("hidden");
        }
      });
    });
    </script>
</body>
</html>
