// confirm-delete.js
document.addEventListener("DOMContentLoaded", function () {
    document.querySelectorAll('.btn-delete').forEach(btn => {
      btn.addEventListener('click', function (e) {
        e.preventDefault(); // cegah link langsung jalan
  
        let url = this.getAttribute('data-url');
  
        Swal.fire({
          title: 'Yakin ingin menghapus?',
          text: "Data yang dihapus tidak bisa dikembalikan!",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#e3342f',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Ya, Hapus!',
          cancelButtonText: 'Batal',
          showClass: {
            popup: 'animate__animated animate__zoomIn animate__faster'
          },
          hideClass: {
            popup: 'animate__animated animate__fadeOutUp animate__faster'
          }
        }).then((result) => {
          if (result.isConfirmed) {
            // Redirect ke URL hapus
            window.location.href = url;
  
            // Toast notifikasi (muncul sebentar di pojok kanan atas)
            Swal.fire({
              toast: true,
              position: 'top-end',
              icon: 'success',
              title: 'Data berhasil dihapus!',
              showConfirmButton: false,
              timer: 2000,
              timerProgressBar: true
            });
          }
        });
      });
    });
  });
  