<?php
header("Content-Type: application/json; charset=UTF-8");
// Matikan cache browser
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");
header("Expires: 0");

// Fungsi load JSON
function loadJson($file) {
    if (file_exists($file)) {
        $data = json_decode(file_get_contents($file), true);
        if (json_last_error() === JSON_ERROR_NONE) {
            return $data;
        }
    }
    return [];
}

// Tentukan file JSON mana yang diminta
$type = $_GET['type'] ?? '';
$allowed = [
    // --- Games ---
    "games_pragmatic"   => __DIR__ . "/admin/games_pragmatic.json",
    "games_pgsoft"      => __DIR__ . "/admin/games_pgsoft.json",
    "games_habanero"    => __DIR__ . "/admin/games_habanero.json",
    "games_cq9"         => __DIR__ . "/admin/games_CQ9.json",
    "games_spadegaming" => __DIR__ . "/admin/games_spadegaming.json",
    "games_yggdrasil"   => __DIR__ . "/admin/games_yggdrasil.json",
    "games_redtiger"    => __DIR__ . "/admin/games_redtiger.json",
    "games_netent"      => __DIR__ . "/admin/games_netent.json",
    "games_playtech"    => __DIR__ . "/admin/games_playtech.json",
    "games_microgaming" => __DIR__ . "/admin/games_microgaming.json",
    "games_joker"       => __DIR__ . "/admin/games_joker.json",
    "games_nolimitcity" => __DIR__ . "/admin/games_nolimitcity.json",
    "games_evo"         => __DIR__ . "/admin/games_evo.json",

    // --- Config umum ---
    "providers"   => __DIR__ . "/admin/providers.json",
    "seo"         => __DIR__ . "/admin/seo.json",
    "info"        => __DIR__ . "/admin/info.json",
    "appearance"  => __DIR__ . "/admin/appearance.json",
    "links"       => __DIR__ . "/admin/links.json",
    "article"     => __DIR__ . "/admin/article.json",
];

if (array_key_exists($type, $allowed)) {
    $data = loadJson($allowed[$type]);

    // Pastikan OPcache reset agar selalu fresh
    if (function_exists('opcache_invalidate')) {
        opcache_invalidate($allowed[$type], true);
    }

    echo json_encode([
        "status" => "success",
        "data" => $data
    ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid type"
    ]);
}
